
// Internal node for the PRQuadTree
public class PRQuadTreeNodeInternal implements PRQuadTreeNode {
	// Node in each quadrant
	private Handle NW;
	private Handle NE;
	private Handle SW;
	private Handle SE;
	
	private Handle flyweight;
	
	private NodeSerializer serializer;

	// Constructor to initialize the node with flyweights
	public PRQuadTreeNodeInternal(Handle flyweight, NodeSerializer mem) {
		serializer = mem;
		// Initialize all subnodes with the flyweight
		NW = NE = SW = SE = flyweight;
		this.flyweight = flyweight;
	}
	
	// Queries if all subnodes are flyweights
	public boolean isEmpty() {
		return (NW == flyweight)&&(NE == flyweight)&&
				(SW == flyweight)&&(SE == flyweight);
	}
	
	// Test if node contains other internal nodes
	public boolean containsAllLeavesOrFlyweight() {
		// Queries if all subnodes are either leaves or flyweights
		return (serializer.handleToNode(NW) instanceof PRQuadTreeNodeLeaf || serializer.handleToNode(NW) instanceof PRQuadTreeNodeFlyweight) &&
				(serializer.handleToNode(NE) instanceof PRQuadTreeNodeLeaf || serializer.handleToNode(NE) instanceof PRQuadTreeNodeFlyweight) &&
				(serializer.handleToNode(SW) instanceof PRQuadTreeNodeLeaf || serializer.handleToNode(SW) instanceof PRQuadTreeNodeFlyweight) &&
				(serializer.handleToNode(SE) instanceof PRQuadTreeNodeLeaf || serializer.handleToNode(SE) instanceof PRQuadTreeNodeFlyweight);
	}
	
	// Returns the number of all records in all subleaves
	public int countOfAllLeafNodes() {
		int ret = 0;
		if (serializer.handleToNode(NW) instanceof PRQuadTreeNodeLeaf)
			ret += ((PRQuadTreeNodeLeaf) serializer.handleToNode(NW)).getCount();
		if (serializer.handleToNode(NE) instanceof PRQuadTreeNodeLeaf)
			ret += ((PRQuadTreeNodeLeaf) serializer.handleToNode(NE)).getCount();
		if (serializer.handleToNode(SW) instanceof PRQuadTreeNodeLeaf)
			ret += ((PRQuadTreeNodeLeaf) serializer.handleToNode(SW)).getCount();
		if (serializer.handleToNode(SE) instanceof PRQuadTreeNodeLeaf)
			ret += ((PRQuadTreeNodeLeaf) serializer.handleToNode(SE)).getCount();
		return ret;
	}
	
	// Returns the number of records in a node if it is a leaf node
	public int countOfLeafNode(PRQuadTreeNode node) {
		if (node instanceof PRQuadTreeNodeLeaf)
			return ((PRQuadTreeNodeLeaf) node).getCount();
		else
			return 0;
	}
	
	// Encapsulation functions
	public Handle getNW() {
		return NW;
	}
	public void setNW(Handle nW) {
		NW = nW;
	}
	public Handle getNE() {
		return NE;
	}
	public void setNE(Handle nE) {
		NE = nE;
	}
	public Handle getSW() {
		return SW;
	}
	public void setSW(Handle sW) {
		SW = sW;
	}
	public Handle getSE() {
		return SE;
	}
	public void setSE(Handle sE) {
		SE = sE;
	}
}
